uniform mat4 coin_ModelViewMatrixAtShaderNodeInverse;

void main(void)
{
  gl_Position  = ftransform();
  gl_FrontColor.rgb = gl_Normal;
  //gl_BackColor.rgb  = gl_Normal;
  
  vec4 modelPosition = coin_ModelViewMatrixAtShaderNodeInverse * gl_ModelViewMatrix * gl_Vertex;
  modelPosition = clamp( modelPosition, 0.0, 10.0 );
  
  //gl_FrontColor.r = (modelPosition.y / 10.0);
  //gl_FrontColor.g = (modelPosition.y / 10.0);
  //gl_FrontColor.b = (modelPosition.y / 10.0);
  
  //vary alpha using local y coord of vertex
  gl_FrontColor.a = 1.0 - (modelPosition.y / 10.0);
  gl_FrontColor = clamp( gl_FrontColor, 0.0, 1.0 );
  gl_FrontColor.a *= gl_FrontColor.a;
  gl_FrontColor.a *= .5;
  
  //truncate color channels so we can composite correctly later
  gl_FrontColor = min(gl_FrontColor, vec4(gl_FrontColor.a, gl_FrontColor.a, gl_FrontColor.a, gl_FrontColor.a));
}